// Copyright 2025 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v1.10.1 with parameter "target=dts+js"
// @generated from file livekit_token_source.proto (package livekit, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3 } from "@bufbuild/protobuf";
import type { RoomConfiguration } from "./livekit_room_pb.js";

/**
 * @generated from message livekit.TokenSourceRequest
 */
export declare class TokenSourceRequest extends Message<TokenSourceRequest> {
  /**
   * The name of the room being requested when generating credentials
   *
   * @generated from field: optional string room_name = 1;
   */
  roomName?: string;

  /**
   * The name of the participant being requested for this client when generating credentials
   *
   * @generated from field: optional string participant_name = 2;
   */
  participantName?: string;

  /**
   * The identity of the participant being requested for this client when generating credentials
   *
   * @generated from field: optional string participant_identity = 3;
   */
  participantIdentity?: string;

  /**
   * Any participant metadata being included along with the credentials generation operation
   *
   * @generated from field: optional string participant_metadata = 4;
   */
  participantMetadata?: string;

  /**
   * Any participant attributes being included along with the credentials generation operation
   *
   * @generated from field: map<string, string> participant_attributes = 5;
   */
  participantAttributes: { [key: string]: string };

  /**
   * A RoomConfiguration object can be passed to request extra parameters should be included when
   * generating connection credentials - dispatching agents, defining egress settings, etc
   * More info: https://docs.livekit.io/home/get-started/authentication/#room-configuration
   *
   * @generated from field: optional livekit.RoomConfiguration room_config = 6;
   */
  roomConfig?: RoomConfiguration;

  constructor(data?: PartialMessage<TokenSourceRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.TokenSourceRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TokenSourceRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TokenSourceRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TokenSourceRequest;

  static equals(a: TokenSourceRequest | PlainMessage<TokenSourceRequest> | undefined, b: TokenSourceRequest | PlainMessage<TokenSourceRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.TokenSourceResponse
 */
export declare class TokenSourceResponse extends Message<TokenSourceResponse> {
  /**
   * @generated from field: string server_url = 1;
   */
  serverUrl: string;

  /**
   * @generated from field: string participant_token = 2;
   */
  participantToken: string;

  constructor(data?: PartialMessage<TokenSourceResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.TokenSourceResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TokenSourceResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TokenSourceResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TokenSourceResponse;

  static equals(a: TokenSourceResponse | PlainMessage<TokenSourceResponse> | undefined, b: TokenSourceResponse | PlainMessage<TokenSourceResponse> | undefined): boolean;
}

